/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchsupport.jobs.core;

import com.floragunn.searchsupport.client.Actions;
import com.floragunn.searchsupport.jobs.JobConfigListener;
import com.floragunn.searchsupport.jobs.actions.CheckForExecutingTriggerAction;
import com.floragunn.searchsupport.jobs.actions.CheckForExecutingTriggerRequest;
import com.floragunn.searchsupport.jobs.actions.CheckForExecutingTriggerResponse;
import com.floragunn.searchsupport.jobs.cluster.DistributedJobStore;
import com.floragunn.searchsupport.jobs.config.JobConfig;
import com.floragunn.searchsupport.jobs.config.JobConfigFactory;
import com.floragunn.searchsupport.jobs.config.JobDetailWithBaseConfig;
import com.floragunn.searchsupport.util.SingleElementBlockingQueue;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.MapMaker;
import com.google.common.collect.Sets;
import com.google.common.collect.Table;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.UUID;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.admin.cluster.health.ClusterHealthResponse;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.ClusterChangedEvent;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.index.IndexNotFoundException;
import org.elasticsearch.index.query.IdsQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentFactory;
import org.quartz.Calendar;
import org.quartz.DailyTimeIntervalTrigger;
import org.quartz.Job;
import org.quartz.JobBuilder;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.JobKey;
import org.quartz.JobPersistenceException;
import org.quartz.ObjectAlreadyExistsException;
import org.quartz.ScheduleBuilder;
import org.quartz.SchedulerConfigException;
import org.quartz.SchedulerException;
import org.quartz.SimpleTrigger;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.TriggerKey;
import org.quartz.impl.matchers.GroupMatcher;
import org.quartz.impl.matchers.StringMatcher;
import org.quartz.impl.triggers.CalendarIntervalTriggerImpl;
import org.quartz.impl.triggers.DailyTimeIntervalTriggerImpl;
import org.quartz.impl.triggers.SimpleTriggerImpl;
import org.quartz.spi.ClassLoadHelper;
import org.quartz.spi.OperableTrigger;
import org.quartz.spi.SchedulerSignaler;
import org.quartz.spi.TriggerFiredBundle;
import org.quartz.spi.TriggerFiredResult;
import org.quartz.utils.Key;

public class IndexJobStateStore<JobType extends JobConfig>
implements DistributedJobStore {
    public static boolean includeNodeIdInSchedulerToJobStoreMapKeys = false;
    private static final Logger log = LogManager.getLogger(IndexJobStateStore.class);
    private static final Map<String, IndexJobStateStore<?>> schedulerToJobStoreMap = new MapMaker().concurrencyLevel(4).weakValues().makeMap();
    private final String schedulerName;
    private final String statusIndexName;
    private final String statusIndexIdPrefix;
    private final String nodeId;
    private final Client client;
    private SchedulerSignaler signaler;
    private final Map<JobKey, InternalJobDetail> keyToJobMap = new HashMap<JobKey, InternalJobDetail>();
    private final Map<TriggerKey, InternalOperableTrigger> keyToTriggerMap = new HashMap<TriggerKey, InternalOperableTrigger>();
    private final Table<String, JobKey, InternalJobDetail> groupAndKeyToJobMap = HashBasedTable.create();
    private final Table<String, TriggerKey, InternalOperableTrigger> groupAndKeyToTriggerMap = HashBasedTable.create();
    private final ActiveTriggerQueue activeTriggers = new ActiveTriggerQueue();
    private final Set<String> pausedTriggerGroups = new HashSet<String>();
    private final Set<String> pausedJobGroups = new HashSet<String>();
    private final Set<JobKey> blockedJobs = new HashSet<JobKey>();
    private final Set<InternalOperableTrigger> triggersStillExecutingOnOtherNodes = new HashSet<InternalOperableTrigger>();
    private final Iterable<JobType> jobConfigSource;
    private final JobConfigFactory<JobType> jobFactory;
    private volatile boolean shutdown = false;
    private volatile boolean initialized;
    private long misfireThreshold = 5000L;
    private ThreadLocal<Set<InternalOperableTrigger>> dirtyTriggers = ThreadLocal.withInitial(() -> new HashSet());
    private final ExecutorService configChangeExecutor = new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, (BlockingQueue<Runnable>)new SingleElementBlockingQueue());
    private final ScheduledThreadPoolExecutor periodicMaintenanceExecutor = new ScheduledThreadPoolExecutor(1);
    private final ClusterService clusterService;
    private final Collection<JobConfigListener<JobType>> jobConfigListeners;

    public static IndexJobStateStore<?> getInstanceBySchedulerName(String nodeId, String schedulerName) {
        if (includeNodeIdInSchedulerToJobStoreMapKeys) {
            return schedulerToJobStoreMap.get(nodeId + "::" + schedulerName);
        }
        return schedulerToJobStoreMap.get(schedulerName);
    }

    public IndexJobStateStore(String schedulerName, String statusIndexName, String statusIndexIdPrefix, String nodeId, Client client, Iterable<JobType> jobConfigSource, JobConfigFactory<JobType> jobFactory, ClusterService clusterService, Collection<JobConfigListener<JobType>> jobConfigListeners) {
        this.schedulerName = schedulerName;
        this.statusIndexName = statusIndexName;
        this.statusIndexIdPrefix = statusIndexIdPrefix;
        this.nodeId = nodeId;
        this.client = client;
        this.jobConfigSource = jobConfigSource;
        this.jobFactory = jobFactory;
        this.clusterService = clusterService;
        this.jobConfigListeners = new ArrayList<JobConfigListener<JobType>>(jobConfigListeners);
    }

    @Override
    public void clusterConfigChanged(ClusterChangedEvent event) {
        log.debug("Cluster config changed; shutdown: " + this.shutdown);
        if (this.shutdown) {
            return;
        }
        this.resetJobs();
        this.configChangeExecutor.submit(() -> this.updateAfterClusterConfigChange());
    }

    public void initialize(ClassLoadHelper loadHelper, SchedulerSignaler signaler) throws SchedulerConfigException {
        this.signaler = signaler;
        if (includeNodeIdInSchedulerToJobStoreMapKeys) {
            schedulerToJobStoreMap.put(this.nodeId + "::" + this.schedulerName, this);
        } else {
            schedulerToJobStoreMap.put(this.schedulerName, this);
        }
        try {
            this.initJobs();
        }
        catch (Exception e) {
            if (this.clusterService != null) {
                log.info("Error while initializing " + this + "\nWill try again during the next cluster change", (Throwable)e);
            }
            throw new SchedulerConfigException("Error while initializing " + this, (Throwable)e);
        }
    }

    public void schedulerStarted() throws SchedulerException {
    }

    public void schedulerPaused() {
    }

    public void schedulerResumed() {
    }

    public void shutdown() {
        if (!this.shutdown) {
            log.info("Shutdown of " + this);
            this.shutdown = true;
            this.configChangeExecutor.shutdownNow();
        }
    }

    public boolean supportsPersistence() {
        return true;
    }

    public long getEstimatedTimeToReleaseAndAcquireTrigger() {
        return 10L;
    }

    public boolean isClustered() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storeJobAndTrigger(JobDetail newJob, OperableTrigger newTrigger) throws ObjectAlreadyExistsException, JobPersistenceException {
        InternalOperableTrigger internalOperableTrigger;
        IndexJobStateStore indexJobStateStore = this;
        synchronized (indexJobStateStore) {
            this.storeJob(newJob, false);
            internalOperableTrigger = this.storeTriggerInHeap(newTrigger, false);
        }
        this.setTriggerStatusInIndex(internalOperableTrigger);
    }

    public synchronized void storeJob(JobDetail newJob, boolean replaceExisting) throws ObjectAlreadyExistsException, JobPersistenceException {
        JobConfig baseConfig = null;
        if (newJob instanceof JobDetailWithBaseConfig) {
            baseConfig = ((JobDetailWithBaseConfig)newJob).getBaseConfig();
        }
        InternalJobDetail newJobLocal = new InternalJobDetail(newJob, baseConfig, this);
        this.addToCollections(newJobLocal);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storeJobsAndTriggers(Map<JobDetail, Set<? extends Trigger>> triggersAndJobs, boolean replace) throws ObjectAlreadyExistsException, JobPersistenceException {
        ArrayList<InternalOperableTrigger> internalOperableTriggers = new ArrayList<InternalOperableTrigger>();
        IndexJobStateStore indexJobStateStore = this;
        synchronized (indexJobStateStore) {
            for (Map.Entry<JobDetail, Set<? extends Trigger>> entry : triggersAndJobs.entrySet()) {
                this.storeJob(entry.getKey(), true);
                for (Trigger trigger : entry.getValue()) {
                    internalOperableTriggers.add(this.storeTriggerInHeap((OperableTrigger)trigger, true));
                }
            }
        }
        for (InternalOperableTrigger internalOperableTrigger : internalOperableTriggers) {
            this.setTriggerStatusInIndex(internalOperableTrigger);
        }
    }

    public void storeTrigger(OperableTrigger newTrigger, boolean replaceExisting) throws ObjectAlreadyExistsException, JobPersistenceException {
        InternalOperableTrigger internalOperableTrigger = this.storeTriggerInHeap(newTrigger, replaceExisting);
        this.setTriggerStatusInIndex(internalOperableTrigger);
    }

    public synchronized boolean removeJob(JobKey jobKey) {
        boolean result = false;
        List<OperableTrigger> triggers = this.getTriggersForJob(jobKey);
        for (OperableTrigger trigger : triggers) {
            this.removeTrigger(trigger.getKey());
            result = true;
        }
        if (this.keyToJobMap.remove(jobKey) != null) {
            result = true;
        }
        this.groupAndKeyToJobMap.remove((Object)jobKey.getGroup(), (Object)jobKey);
        return result;
    }

    public synchronized boolean removeJobs(List<JobKey> jobKeys) throws JobPersistenceException {
        boolean result = true;
        for (JobKey jobKey : jobKeys) {
            if (this.removeJob(jobKey)) continue;
            result = false;
        }
        return result;
    }

    public synchronized boolean removeTrigger(TriggerKey triggerKey) {
        InternalOperableTrigger internalOperableTrigger = this.keyToTriggerMap.remove(triggerKey);
        if (internalOperableTrigger == null) {
            return false;
        }
        this.groupAndKeyToTriggerMap.remove((Object)triggerKey.getGroup(), (Object)triggerKey);
        this.activeTriggers.remove(internalOperableTrigger);
        InternalJobDetail internalJobDetail = this.keyToJobMap.get(internalOperableTrigger.getJobKey());
        if (internalJobDetail != null) {
            internalJobDetail.triggers.remove(internalOperableTrigger);
            if (internalJobDetail.triggers.isEmpty()) {
                this.removeJob(internalJobDetail.getKey());
            }
        }
        return true;
    }

    public synchronized boolean removeTriggers(List<TriggerKey> triggerKeys) throws JobPersistenceException {
        boolean result = true;
        for (TriggerKey triggerKey : triggerKeys) {
            if (this.removeTrigger(triggerKey)) continue;
            result = false;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean replaceTrigger(TriggerKey triggerKey, OperableTrigger newTrigger) throws JobPersistenceException {
        InternalOperableTrigger internalOperableTrigger;
        IndexJobStateStore indexJobStateStore = this;
        synchronized (indexJobStateStore) {
            internalOperableTrigger = this.keyToTriggerMap.get(triggerKey);
            if (internalOperableTrigger == null) {
                return false;
            }
            internalOperableTrigger.setDelegate(newTrigger);
            if (this.updateTriggerStateToIdle(internalOperableTrigger)) {
                this.activeTriggers.add(internalOperableTrigger);
            } else {
                this.activeTriggers.remove(internalOperableTrigger);
            }
        }
        this.setTriggerStatusInIndex(internalOperableTrigger);
        return true;
    }

    public synchronized JobDetail retrieveJob(JobKey jobKey) throws JobPersistenceException {
        return this.keyToJobMap.get(jobKey);
    }

    public synchronized OperableTrigger retrieveTrigger(TriggerKey triggerKey) throws JobPersistenceException {
        return this.keyToTriggerMap.get(triggerKey);
    }

    public synchronized boolean checkExists(JobKey jobKey) throws JobPersistenceException {
        return this.keyToJobMap.containsKey(jobKey);
    }

    public synchronized boolean checkExists(TriggerKey triggerKey) throws JobPersistenceException {
        return this.keyToTriggerMap.containsKey(triggerKey);
    }

    public void clearAllSchedulingData() throws JobPersistenceException {
        this.keyToJobMap.clear();
        this.keyToTriggerMap.clear();
        this.groupAndKeyToJobMap.clear();
        this.groupAndKeyToTriggerMap.clear();
    }

    public void storeCalendar(String name, Calendar calendar, boolean replaceExisting, boolean updateTriggers) throws ObjectAlreadyExistsException, JobPersistenceException {
        throw new UnsupportedOperationException();
    }

    public boolean removeCalendar(String calName) throws JobPersistenceException {
        return false;
    }

    public Calendar retrieveCalendar(String calName) {
        return null;
    }

    public synchronized int getNumberOfJobs() throws JobPersistenceException {
        return this.keyToJobMap.size();
    }

    public synchronized int getNumberOfTriggers() throws JobPersistenceException {
        return this.keyToTriggerMap.size();
    }

    public synchronized int getNumberOfCalendars() throws JobPersistenceException {
        return 0;
    }

    public synchronized Set<JobKey> getJobKeys(GroupMatcher<JobKey> matcher) throws JobPersistenceException {
        if (matcher.getCompareWithOperator() == StringMatcher.StringOperatorName.EQUALS) {
            return Collections.unmodifiableSet(this.groupAndKeyToJobMap.row((Object)matcher.getCompareToValue()).keySet());
        }
        HashSet<JobKey> result = new HashSet<JobKey>();
        StringMatcher.StringOperatorName operator = matcher.getCompareWithOperator();
        String matcherValue = matcher.getCompareToValue();
        for (Map.Entry entry : this.groupAndKeyToJobMap.rowMap().entrySet()) {
            if (!operator.evaluate((String)entry.getKey(), matcherValue)) continue;
            result.addAll(((Map)entry.getValue()).keySet());
        }
        return result;
    }

    public synchronized Set<TriggerKey> getTriggerKeys(GroupMatcher<TriggerKey> matcher) throws JobPersistenceException {
        if (matcher.getCompareWithOperator() == StringMatcher.StringOperatorName.EQUALS) {
            return Collections.unmodifiableSet(this.groupAndKeyToTriggerMap.row((Object)matcher.getCompareToValue()).keySet());
        }
        HashSet<TriggerKey> result = new HashSet<TriggerKey>();
        StringMatcher.StringOperatorName operator = matcher.getCompareWithOperator();
        String matcherValue = matcher.getCompareToValue();
        for (Map.Entry entry : this.groupAndKeyToTriggerMap.rowMap().entrySet()) {
            if (!operator.evaluate((String)entry.getKey(), matcherValue)) continue;
            result.addAll(((Map)entry.getValue()).keySet());
        }
        return result;
    }

    public synchronized List<String> getJobGroupNames() throws JobPersistenceException {
        return new ArrayList<String>(this.groupAndKeyToJobMap.rowKeySet());
    }

    public synchronized List<String> getTriggerGroupNames() throws JobPersistenceException {
        return new ArrayList<String>(this.groupAndKeyToTriggerMap.rowKeySet());
    }

    public synchronized List<String> getCalendarNames() throws JobPersistenceException {
        return Collections.emptyList();
    }

    public synchronized List<OperableTrigger> getTriggersForJob(JobKey jobKey) {
        InternalJobDetail internalJobDetail = this.keyToJobMap.get(jobKey);
        if (internalJobDetail == null) {
            return null;
        }
        return internalJobDetail.triggers.stream().map(s -> ((InternalOperableTrigger)s).delegate).collect(Collectors.toList());
    }

    public synchronized Trigger.TriggerState getTriggerState(TriggerKey triggerKey) throws JobPersistenceException {
        InternalOperableTrigger internalOperableTrigger = this.keyToTriggerMap.get(triggerKey);
        if (internalOperableTrigger == null) {
            return Trigger.TriggerState.NONE;
        }
        return internalOperableTrigger.state.getTriggerState();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetTriggerFromErrorState(TriggerKey triggerKey) throws JobPersistenceException {
        InternalOperableTrigger internalOperableTrigger;
        IndexJobStateStore indexJobStateStore = this;
        synchronized (indexJobStateStore) {
            internalOperableTrigger = this.keyToTriggerMap.get(triggerKey);
            if (internalOperableTrigger == null || internalOperableTrigger.state != InternalOperableTrigger.State.ERROR) {
                return;
            }
            if (this.updateTriggerStateToIdle(internalOperableTrigger)) {
                this.activeTriggers.add(internalOperableTrigger);
            } else {
                this.activeTriggers.remove(internalOperableTrigger);
            }
        }
        this.setTriggerStatusInIndex(internalOperableTrigger);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pauseTrigger(TriggerKey triggerKey) throws JobPersistenceException {
        InternalOperableTrigger internalOperableTrigger;
        IndexJobStateStore indexJobStateStore = this;
        synchronized (indexJobStateStore) {
            internalOperableTrigger = this.keyToTriggerMap.get(triggerKey);
            if (!this.pauseTriggerInHeap(internalOperableTrigger)) {
                return;
            }
        }
        this.setTriggerStatusInIndex(internalOperableTrigger);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<String> pauseTriggers(GroupMatcher<TriggerKey> matcher) throws JobPersistenceException {
        Collection result;
        IndexJobStateStore indexJobStateStore = this;
        synchronized (indexJobStateStore) {
            Collection<InternalOperableTrigger> matchedTriggers = this.matchTriggers(matcher);
            if (matchedTriggers.isEmpty()) {
                return Collections.emptyList();
            }
            for (InternalOperableTrigger internalOperableTrigger : matchedTriggers) {
                this.pauseTriggerInHeap(internalOperableTrigger);
            }
            result = matchedTriggers.stream().map(t -> t.getKey().getGroup()).collect(Collectors.toSet());
        }
        this.flushDirtyTriggersToIndex();
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pauseJob(JobKey jobKey) throws JobPersistenceException {
        IndexJobStateStore indexJobStateStore = this;
        synchronized (indexJobStateStore) {
            InternalJobDetail internalJobDetail = this.keyToJobMap.get(jobKey);
            if (internalJobDetail == null) {
                return;
            }
            for (InternalOperableTrigger internalOperableTrigger : internalJobDetail.triggers) {
                this.pauseTriggerInHeap(internalOperableTrigger);
            }
        }
        this.flushDirtyTriggersToIndex();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<String> pauseJobs(GroupMatcher<JobKey> groupMatcher) throws JobPersistenceException {
        Collection result;
        IndexJobStateStore indexJobStateStore = this;
        synchronized (indexJobStateStore) {
            Collection<InternalJobDetail> matchedJobs = this.matchJobs(groupMatcher);
            if (matchedJobs.isEmpty()) {
                return Collections.emptyList();
            }
            for (InternalJobDetail internalJobDetail : matchedJobs) {
                for (InternalOperableTrigger internalOperableTrigger : internalJobDetail.triggers) {
                    this.pauseTriggerInHeap(internalOperableTrigger);
                }
            }
            result = matchedJobs.stream().map(t -> t.getKey().getGroup()).collect(Collectors.toSet());
        }
        this.flushDirtyTriggersToIndex();
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resumeTrigger(TriggerKey triggerKey) throws JobPersistenceException {
        InternalOperableTrigger internalOperableTrigger;
        IndexJobStateStore indexJobStateStore = this;
        synchronized (indexJobStateStore) {
            internalOperableTrigger = this.keyToTriggerMap.get(triggerKey);
            if (!this.resumeTriggerInHeap(internalOperableTrigger)) {
                return;
            }
        }
        this.setTriggerStatusInIndex(internalOperableTrigger);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<String> resumeTriggers(GroupMatcher<TriggerKey> matcher) throws JobPersistenceException {
        Collection result;
        IndexJobStateStore indexJobStateStore = this;
        synchronized (indexJobStateStore) {
            Collection<InternalOperableTrigger> matchedTriggers = this.matchTriggers(matcher);
            if (matchedTriggers.isEmpty()) {
                return Collections.emptyList();
            }
            for (InternalOperableTrigger internalOperableTrigger : matchedTriggers) {
                this.resumeTriggerInHeap(internalOperableTrigger);
            }
            result = matchedTriggers.stream().map(t -> t.getKey().getGroup()).collect(Collectors.toSet());
        }
        this.flushDirtyTriggersToIndex();
        return result;
    }

    public synchronized Set<String> getPausedTriggerGroups() throws JobPersistenceException {
        return Collections.unmodifiableSet(new HashSet<String>(this.pausedTriggerGroups));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resumeJob(JobKey jobKey) throws JobPersistenceException {
        IndexJobStateStore indexJobStateStore = this;
        synchronized (indexJobStateStore) {
            InternalJobDetail internalJobDetail = this.keyToJobMap.get(jobKey);
            if (internalJobDetail == null) {
                return;
            }
            for (InternalOperableTrigger internalOperableTrigger : internalJobDetail.triggers) {
                this.resumeTriggerInHeap(internalOperableTrigger);
            }
        }
        this.flushDirtyTriggersToIndex();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<String> resumeJobs(GroupMatcher<JobKey> groupMatcher) throws JobPersistenceException {
        Collection result;
        IndexJobStateStore indexJobStateStore = this;
        synchronized (indexJobStateStore) {
            Collection<InternalJobDetail> matchedJobs = this.matchJobs(groupMatcher);
            if (matchedJobs.isEmpty()) {
                return Collections.emptyList();
            }
            for (InternalJobDetail internalJobDetail : matchedJobs) {
                for (InternalOperableTrigger internalOperableTrigger : internalJobDetail.triggers) {
                    this.resumeTriggerInHeap(internalOperableTrigger);
                }
            }
            result = matchedJobs.stream().map(t -> t.getKey().getGroup()).collect(Collectors.toSet());
        }
        this.flushDirtyTriggersToIndex();
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pauseAll() throws JobPersistenceException {
        IndexJobStateStore indexJobStateStore = this;
        synchronized (indexJobStateStore) {
            for (InternalOperableTrigger internalOperableTrigger : this.keyToTriggerMap.values()) {
                this.pauseTriggerInHeap(internalOperableTrigger);
            }
        }
        this.flushDirtyTriggersToIndex();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resumeAll() throws JobPersistenceException {
        IndexJobStateStore indexJobStateStore = this;
        synchronized (indexJobStateStore) {
            for (InternalOperableTrigger internalOperableTrigger : this.keyToTriggerMap.values()) {
                this.resumeTriggerInHeap(internalOperableTrigger);
            }
        }
        this.flushDirtyTriggersToIndex();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public List<OperableTrigger> acquireNextTriggers(long noLaterThan, int maxCount, long timeWindow) throws JobPersistenceException {
        if (IndexJobStateStore.log.isDebugEnabled()) {
            IndexJobStateStore.log.debug("acquireNextTriggers(noLaterThan = " + new Date(noLaterThan) + ", maxCount = " + maxCount + ", timeWindow =" + timeWindow + ") for " + this);
        }
        var7_4 = this;
        synchronized (var7_4) {
            if (IndexJobStateStore.log.isDebugEnabled()) {
                IndexJobStateStore.log.debug("Number of active triggers: " + this.activeTriggers.size());
            }
            if (this.activeTriggers.isEmpty()) {
                return Collections.emptyList();
            }
            IndexJobStateStore.log.debug("Active triggers: " + this.activeTriggers);
            result = new ArrayList<OperableTrigger>(Math.min(maxCount, this.activeTriggers.size()));
            acquiredJobKeysForNoConcurrentExec = new HashSet<JobKey>();
            excludedTriggers = new HashSet<InternalOperableTrigger>();
            misfireIsBefore = System.currentTimeMillis() - this.misfireThreshold;
            batchEnd = noLaterThan;
            activeTrigger = this.activeTriggers.pollFirst();
            while (activeTrigger != null) {
                block12: {
                    block13: {
                        if (activeTrigger.getNextFireTime() == null) break block12;
                        trigger = ActiveTrigger.access$200(activeTrigger);
                        if (!this.checkForMisfire(trigger, misfireIsBefore)) break block13;
                        if (trigger.getNextFireTime() != null) {
                            this.activeTriggers.add(trigger);
                        }
                        this.markDirty(trigger);
                        break block12;
                    }
                    if (activeTrigger.getNextFireTime().getTime() > batchEnd) {
                        this.activeTriggers.add(trigger);
                        break;
                    }
                    internalJobDetail = this.keyToJobMap.get(trigger.getJobKey());
                    if (!internalJobDetail.isConcurrentExectionDisallowed()) ** GOTO lbl37
                    if (acquiredJobKeysForNoConcurrentExec.contains(internalJobDetail.getKey())) {
                        excludedTriggers.add(trigger);
                    } else {
                        acquiredJobKeysForNoConcurrentExec.add(trigger.getJobKey());
lbl37:
                        // 2 sources

                        trigger.setStateAndNode(InternalOperableTrigger.State.ACQUIRED, this.nodeId);
                        trigger.setFireInstanceId(UUID.randomUUID().toString());
                        if (result.isEmpty()) {
                            batchEnd = Math.max(activeTrigger.getNextFireTime().getTime(), System.currentTimeMillis()) + timeWindow;
                        }
                        result.add(trigger);
                        if (result.size() >= maxCount) break;
                    }
                }
                activeTrigger = this.activeTriggers.pollFirst();
            }
            this.activeTriggers.addAll(excludedTriggers);
        }
        this.flushDirtyTriggersToIndex();
        IndexJobStateStore.log.debug("Result: " + result);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseAcquiredTrigger(OperableTrigger trigger) {
        InternalOperableTrigger internalOperableTrigger;
        IndexJobStateStore indexJobStateStore = this;
        synchronized (indexJobStateStore) {
            internalOperableTrigger = this.keyToTriggerMap.get(trigger.getKey());
            if (internalOperableTrigger == null) {
                return;
            }
            if (internalOperableTrigger.state != InternalOperableTrigger.State.ACQUIRED) {
                return;
            }
            internalOperableTrigger.state = InternalOperableTrigger.State.WAITING;
            this.activeTriggers.add(internalOperableTrigger);
        }
        this.setTriggerStatusInIndex(internalOperableTrigger);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<TriggerFiredResult> triggersFired(List<OperableTrigger> firedTriggers) throws JobPersistenceException {
        ArrayList<TriggerFiredResult> results = new ArrayList<TriggerFiredResult>(firedTriggers.size());
        if (log.isDebugEnabled()) {
            log.debug("triggersFired(" + firedTriggers + ")");
        }
        IndexJobStateStore indexJobStateStore = this;
        synchronized (indexJobStateStore) {
            for (OperableTrigger trigger : firedTriggers) {
                InternalOperableTrigger internalOperableTrigger = this.toInternal(trigger);
                if (internalOperableTrigger == null || internalOperableTrigger.state != InternalOperableTrigger.State.ACQUIRED) continue;
                InternalJobDetail jobDetail = this.keyToJobMap.get(trigger.getJobKey());
                if (jobDetail == null) {
                    if (log.isDebugEnabled()) {
                        log.debug("Could not find job detail for fired trigger: " + trigger + "; this probably means that the job was deleted after the trigger was acquired. Skipping this trigger");
                    }
                    this.activeTriggers.remove(internalOperableTrigger);
                    internalOperableTrigger.state = InternalOperableTrigger.State.DELETED;
                    this.markDirty(internalOperableTrigger);
                    continue;
                }
                Date previousFireTime = trigger.getPreviousFireTime();
                Date scheduledFireTime = trigger.getNextFireTime();
                this.activeTriggers.remove(internalOperableTrigger);
                internalOperableTrigger.triggered(null);
                internalOperableTrigger.state = InternalOperableTrigger.State.EXECUTING;
                internalOperableTrigger.node = this.nodeId;
                this.markDirty(internalOperableTrigger);
                TriggerFiredBundle triggerFiredBundle = new TriggerFiredBundle((JobDetail)jobDetail, trigger, null, false, new Date(), scheduledFireTime, previousFireTime, trigger.getNextFireTime());
                if (jobDetail.isConcurrentExectionDisallowed()) {
                    jobDetail.blockIdleTriggers();
                } else if (internalOperableTrigger.getNextFireTime() != null) {
                    this.activeTriggers.add(internalOperableTrigger);
                }
                results.add(new TriggerFiredResult(triggerFiredBundle));
            }
        }
        this.flushDirtyTriggersToIndex();
        if (log.isDebugEnabled()) {
            log.debug("triggersFired() = " + results);
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void triggeredJobComplete(OperableTrigger trigger, JobDetail jobDetail, Trigger.CompletedExecutionInstruction triggerInstCode) {
        if (log.isDebugEnabled()) {
            log.debug("triggeredJobComplete(" + trigger + ")");
        }
        IndexJobStateStore indexJobStateStore = this;
        synchronized (indexJobStateStore) {
            InternalJobDetail internalJobDetail = this.toInternal(jobDetail);
            InternalOperableTrigger internalOperableTrigger = this.toInternal(trigger);
            if (internalJobDetail != null) {
                if (internalJobDetail.isPersistJobDataAfterExecution()) {
                    JobDataMap newData = jobDetail.getJobDataMap();
                    if (newData != null) {
                        newData = (JobDataMap)newData.clone();
                        newData.clearDirtyFlag();
                    }
                    internalJobDetail.delegate = internalJobDetail.getJobBuilder().setJobData(newData).build();
                }
                if (internalJobDetail.isConcurrentExectionDisallowed()) {
                    internalJobDetail.deblockTriggers();
                    this.signaler.signalSchedulingChange(0L);
                }
            } else {
                this.blockedJobs.remove(jobDetail.getKey());
            }
            if (internalOperableTrigger != null) {
                switch (triggerInstCode) {
                    case DELETE_TRIGGER: {
                        log.error("DELETE_TRIGGER is not supported: " + internalOperableTrigger);
                        internalOperableTrigger.setState(InternalOperableTrigger.State.ERROR);
                        this.activeTriggers.remove(internalOperableTrigger);
                        this.signaler.signalSchedulingChange(0L);
                        break;
                    }
                    case SET_TRIGGER_COMPLETE: {
                        internalOperableTrigger.setState(InternalOperableTrigger.State.COMPLETE);
                        this.activeTriggers.remove(internalOperableTrigger);
                        this.signaler.signalSchedulingChange(0L);
                        break;
                    }
                    case SET_TRIGGER_ERROR: {
                        internalOperableTrigger.setState(InternalOperableTrigger.State.ERROR);
                        this.activeTriggers.remove(internalOperableTrigger);
                        this.signaler.signalSchedulingChange(0L);
                        break;
                    }
                    case SET_ALL_JOB_TRIGGERS_ERROR: {
                        this.setAllTriggersOfJobToState(internalJobDetail, InternalOperableTrigger.State.ERROR);
                        this.signaler.signalSchedulingChange(0L);
                        break;
                    }
                    case SET_ALL_JOB_TRIGGERS_COMPLETE: {
                        this.setAllTriggersOfJobToState(internalJobDetail, InternalOperableTrigger.State.COMPLETE);
                        this.signaler.signalSchedulingChange(0L);
                        break;
                    }
                    default: {
                        internalOperableTrigger.setState(InternalOperableTrigger.State.WAITING);
                        if (!this.keyToJobMap.containsKey(internalOperableTrigger.getJobKey())) break;
                        this.activeTriggers.add(internalOperableTrigger);
                    }
                }
            }
        }
        this.flushDirtyTriggersToIndex();
    }

    public void setInstanceId(String schedInstId) {
    }

    public void setInstanceName(String schedName) {
    }

    public void setThreadPoolSize(int poolSize) {
    }

    public long getAcquireRetryDelay(int failureCount) {
        return 20L;
    }

    public String getNodeId() {
        return this.nodeId;
    }

    private InternalJobDetail toInternal(JobDetail jobDetail) {
        if (jobDetail instanceof InternalJobDetail) {
            return (InternalJobDetail)jobDetail;
        }
        return this.keyToJobMap.get(jobDetail.getKey());
    }

    private InternalOperableTrigger toInternal(OperableTrigger trigger) {
        if (trigger instanceof InternalOperableTrigger) {
            return (InternalOperableTrigger)trigger;
        }
        return this.keyToTriggerMap.get(trigger.getKey());
    }

    private synchronized InternalOperableTrigger storeTriggerInHeap(OperableTrigger newTrigger, boolean replaceExisting) throws ObjectAlreadyExistsException, JobPersistenceException {
        InternalJobDetail internalJobDetail = this.keyToJobMap.get(newTrigger.getJobKey());
        if (internalJobDetail == null) {
            throw new JobPersistenceException("Trigger " + newTrigger + " references non-existing job" + newTrigger.getJobKey());
        }
        return this.storeTriggerInHeap(internalJobDetail, newTrigger);
    }

    private synchronized InternalOperableTrigger storeTriggerInHeap(InternalJobDetail internalJobDetail, OperableTrigger newTrigger) {
        InternalOperableTrigger internalOperableTrigger = new InternalOperableTrigger(this, newTrigger);
        internalJobDetail.addTrigger(internalOperableTrigger);
        this.addToCollections(internalOperableTrigger);
        internalOperableTrigger.computeFirstFireTime(null);
        internalOperableTrigger.node = this.nodeId;
        this.updateTriggerStateToIdle(internalOperableTrigger);
        if (internalOperableTrigger.getState() == InternalOperableTrigger.State.WAITING) {
            this.activeTriggers.add(internalOperableTrigger);
        }
        return internalOperableTrigger;
    }

    private synchronized void addToCollections(InternalJobDetail internalJobDetail) {
        this.keyToJobMap.put(internalJobDetail.getKey(), internalJobDetail);
        this.groupAndKeyToJobMap.put((Object)internalJobDetail.getKey().getGroup(), (Object)internalJobDetail.getKey(), (Object)internalJobDetail);
        if (!internalJobDetail.triggers.isEmpty()) {
            for (InternalOperableTrigger internalOperableTrigger : internalJobDetail.triggers) {
                this.addToCollections(internalOperableTrigger);
            }
        }
    }

    private synchronized void addToCollections(InternalOperableTrigger internalOperableTrigger) {
        this.groupAndKeyToTriggerMap.put((Object)internalOperableTrigger.getKey().getGroup(), (Object)internalOperableTrigger.getKey(), (Object)internalOperableTrigger);
        this.keyToTriggerMap.put(internalOperableTrigger.getKey(), internalOperableTrigger);
    }

    private synchronized void initActiveTriggers() {
        this.activeTriggers.clear();
        for (InternalOperableTrigger trigger : this.keyToTriggerMap.values()) {
            if (trigger.state != InternalOperableTrigger.State.WAITING) continue;
            this.activeTriggers.add(trigger);
        }
    }

    private boolean updateTriggerStateToIdle(InternalOperableTrigger internalOperableTrigger) {
        if (this.pausedTriggerGroups.contains(internalOperableTrigger.getKey().getGroup()) || this.pausedJobGroups.contains(internalOperableTrigger.getJobKey().getGroup())) {
            if (this.blockedJobs.contains(internalOperableTrigger.getJobKey())) {
                internalOperableTrigger.setState(InternalOperableTrigger.State.PAUSED_BLOCKED);
            } else {
                internalOperableTrigger.setState(InternalOperableTrigger.State.PAUSED);
            }
            return false;
        }
        if (this.blockedJobs.contains(internalOperableTrigger.getJobKey())) {
            internalOperableTrigger.setState(InternalOperableTrigger.State.BLOCKED);
            return false;
        }
        internalOperableTrigger.setState(InternalOperableTrigger.State.WAITING);
        return true;
    }

    private void setTriggerStatusInIndex(InternalOperableTrigger internalOperableTrigger) {
        try {
            XContentBuilder xContentBuilder = XContentFactory.jsonBuilder();
            internalOperableTrigger.toXContent(xContentBuilder, ToXContent.EMPTY_PARAMS);
            IndexRequest indexRequest = new IndexRequest(this.statusIndexName).id(internalOperableTrigger.getKeyString()).source(xContentBuilder);
            this.client.index(indexRequest);
        }
        catch (Exception e) {
            log.error("Error while writing trigger status: " + internalOperableTrigger, (Throwable)e);
            this.dirtyTriggers.get().add(internalOperableTrigger);
        }
    }

    private synchronized Collection<InternalOperableTrigger> matchTriggers(GroupMatcher<TriggerKey> matcher) throws JobPersistenceException {
        if (matcher.getCompareWithOperator() == StringMatcher.StringOperatorName.EQUALS) {
            return this.groupAndKeyToTriggerMap.row((Object)matcher.getCompareToValue()).values();
        }
        HashSet<InternalOperableTrigger> result = new HashSet<InternalOperableTrigger>();
        StringMatcher.StringOperatorName operator = matcher.getCompareWithOperator();
        String matcherValue = matcher.getCompareToValue();
        for (Map.Entry entry : this.groupAndKeyToTriggerMap.rowMap().entrySet()) {
            if (!operator.evaluate((String)entry.getKey(), matcherValue)) continue;
            result.addAll(((Map)entry.getValue()).values());
        }
        return result;
    }

    private synchronized Collection<InternalJobDetail> matchJobs(GroupMatcher<JobKey> matcher) throws JobPersistenceException {
        if (matcher.getCompareWithOperator() == StringMatcher.StringOperatorName.EQUALS) {
            return this.groupAndKeyToJobMap.row((Object)matcher.getCompareToValue()).values();
        }
        HashSet<InternalJobDetail> result = new HashSet<InternalJobDetail>();
        StringMatcher.StringOperatorName operator = matcher.getCompareWithOperator();
        String matcherValue = matcher.getCompareToValue();
        for (Map.Entry entry : this.groupAndKeyToJobMap.rowMap().entrySet()) {
            if (!operator.evaluate((String)entry.getKey(), matcherValue)) continue;
            result.addAll(((Map)entry.getValue()).values());
        }
        return result;
    }

    private synchronized boolean pauseTriggerInHeap(InternalOperableTrigger internalOperableTrigger) {
        if (internalOperableTrigger == null || internalOperableTrigger.state == InternalOperableTrigger.State.COMPLETE) {
            return false;
        }
        if (internalOperableTrigger.state == InternalOperableTrigger.State.BLOCKED) {
            internalOperableTrigger.state = InternalOperableTrigger.State.PAUSED_BLOCKED;
        } else {
            internalOperableTrigger.state = InternalOperableTrigger.State.PAUSED;
        }
        this.activeTriggers.remove(internalOperableTrigger);
        this.markDirty(internalOperableTrigger);
        return true;
    }

    private synchronized boolean resumeTriggerInHeap(InternalOperableTrigger internalOperableTrigger) {
        if (internalOperableTrigger == null) {
            return false;
        }
        if (internalOperableTrigger.state != InternalOperableTrigger.State.PAUSED && internalOperableTrigger.state != InternalOperableTrigger.State.PAUSED_BLOCKED) {
            return false;
        }
        internalOperableTrigger.state = InternalOperableTrigger.State.WAITING;
        this.checkForMisfire(internalOperableTrigger);
        if (this.updateTriggerStateToIdle(internalOperableTrigger)) {
            this.activeTriggers.add(internalOperableTrigger);
        } else {
            this.activeTriggers.remove(internalOperableTrigger);
        }
        this.markDirty(internalOperableTrigger);
        return true;
    }

    private synchronized void setAllTriggersOfJobToState(InternalJobDetail internalJobDetail, InternalOperableTrigger.State state) {
        for (InternalOperableTrigger internalOperableTrigger : internalJobDetail.triggers) {
            if (internalOperableTrigger.state == state) continue;
            internalOperableTrigger.state = state;
            if (state != InternalOperableTrigger.State.WAITING) {
                this.activeTriggers.remove(internalOperableTrigger);
            }
            this.markDirty(internalOperableTrigger);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initJobs() {
        Collection<InternalJobDetail> jobs = this.loadJobs();
        boolean triggersStillExecutingOnOtherNodesExist = false;
        IndexJobStateStore indexJobStateStore = this;
        synchronized (indexJobStateStore) {
            this.resetJobs();
            for (InternalJobDetail job : jobs) {
                this.addToCollections(job);
            }
            this.initActiveTriggers();
            if (this.triggersStillExecutingOnOtherNodes.size() > 0) {
                triggersStillExecutingOnOtherNodesExist = true;
            }
            log.info("Scheduler " + this.schedulerName + " is initialized. Jobs: " + jobs.size() + " Active Triggers: " + this.activeTriggers.size());
        }
        this.initialized = true;
        this.flushDirtyTriggersToIndex();
        if (triggersStillExecutingOnOtherNodesExist) {
            this.periodicMaintenanceExecutor.getQueue().clear();
            this.periodicMaintenanceExecutor.schedule(() -> this.checkTriggersStillExecutingOnOtherNodes(), 10L, TimeUnit.SECONDS);
        }
    }

    private void updateAfterClusterConfigChange() {
        block4: {
            try {
                log.info("Reinitializing jobs for " + this);
                this.periodicMaintenanceExecutor.getQueue().clear();
                this.initJobs();
                this.signaler.signalSchedulingChange(0L);
                log.debug("Finished reinitializing jobs for " + this);
            }
            catch (Exception e) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e1) {
                    log.debug((Object)e1);
                }
                if (this.shutdown) break block4;
                log.error("Error while initializing jobs for " + this, (Throwable)e);
            }
        }
    }

    private synchronized void resetJobs() {
        this.keyToJobMap.clear();
        this.keyToTriggerMap.clear();
        this.groupAndKeyToJobMap.clear();
        this.groupAndKeyToTriggerMap.clear();
        this.activeTriggers.clear();
    }

    private Collection<InternalJobDetail> loadJobs() {
        long start = System.currentTimeMillis();
        try {
            if (log.isTraceEnabled()) {
                log.trace("Going to load jobs; ");
            }
            Set<JobType> jobConfigSet = this.loadJobConfigAfterReachingYellowStatus();
            this.notifyJobConfigInitListeners(jobConfigSet);
            if (log.isDebugEnabled()) {
                log.debug("Job configurations loaded: " + jobConfigSet);
            }
            Map<TriggerKey, InternalOperableTrigger> triggerStates = this.loadTriggerStates(jobConfigSet);
            ArrayList<InternalJobDetail> result = new ArrayList<InternalJobDetail>(jobConfigSet.size());
            for (JobConfig jobConfig : jobConfigSet) {
                result.add(this.createInternalJobDetailFromJobConfig(jobConfig, triggerStates));
            }
            if (log.isInfoEnabled()) {
                log.info("Jobs loaded: " + result);
            }
            return result;
        }
        catch (ElasticsearchException e) {
            log.info("loadJobs() failed after " + (System.currentTimeMillis() - start) + " ms", (Throwable)e);
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String updateJobs() {
        Set<JobType> newJobConfig = this.loadJobConfig();
        HashMap<JobKey, InternalJobDetail> newJobs = new HashMap<JobKey, InternalJobDetail>();
        HashMap<JobKey, InternalJobDetail> updatedJobs = new HashMap<JobKey, InternalJobDetail>();
        HashMap<JobKey, InternalJobDetail> deletedJobs = new HashMap<JobKey, InternalJobDetail>();
        HashSet<JobConfig> newJobTypes = new HashSet<JobConfig>();
        HashMap<JobConfig, JobConfig> updatedJobTypes = new HashMap<JobConfig, JobConfig>();
        HashSet<JobConfig> deletedJobTypes = new HashSet<JobConfig>();
        HashSet<JobKey> newJobKeys = new HashSet<JobKey>(newJobConfig.size());
        Map<JobKey, JobType> loadedJobConfig = this.getLoadedJobConfig();
        if (log.isInfoEnabled()) {
            log.info("Updating jobs:\n " + newJobConfig + "\n");
        }
        for (JobConfig newJob : newJobConfig) {
            JobKey jobKey = newJob.getJobKey();
            JobConfig existingJob = (JobConfig)loadedJobConfig.get(jobKey);
            if (existingJob != null) continue;
            newJobTypes.add(newJob);
        }
        this.notifyJobConfigListenersBeforeChange(newJobTypes);
        IndexJobStateStore indexJobStateStore = this;
        synchronized (indexJobStateStore) {
            loadedJobConfig = this.getLoadedJobConfig();
            newJobTypes.clear();
            if (log.isDebugEnabled()) {
                log.debug("Loaded job config:\n" + loadedJobConfig + "\n");
            }
            for (JobConfig newJob : newJobConfig) {
                JobKey jobKey = newJob.getJobKey();
                newJobKeys.add(jobKey);
                JobConfig existingJob = (JobConfig)loadedJobConfig.get(jobKey);
                if (log.isDebugEnabled()) {
                    log.info("New job: " + newJob + "; existing job: " + existingJob);
                }
                if (existingJob == null) {
                    InternalJobDetail newJobDetail = this.createInternalJobDetailFromJobConfig(newJob, Collections.emptyMap());
                    newJobs.put(jobKey, newJobDetail);
                    newJobTypes.add(newJob);
                    this.addToCollections(newJobDetail);
                    newJobDetail.engageTriggers();
                    continue;
                }
                if (existingJob.getVersion() >= newJob.getVersion() && existingJob.getVersion() != -1L && newJob.getVersion() != -1L) continue;
                InternalJobDetail existingJobDetail = this.keyToJobMap.get(existingJob.getJobKey());
                if (existingJobDetail != null) {
                    if (this.updateJob(existingJobDetail, existingJob, newJob)) {
                        updatedJobs.put(jobKey, this.createInternalJobDetailFromJobConfig(newJob, Collections.emptyMap()));
                    }
                    updatedJobTypes.put(existingJob, newJob);
                    continue;
                }
                log.info("Found existing job config but no matching job detail for " + existingJob + ". This is a bit weird. Will create job detail now.");
                InternalJobDetail newJobDetail = this.createInternalJobDetailFromJobConfig(newJob, Collections.emptyMap());
                newJobs.put(jobKey, newJobDetail);
                newJobTypes.add(newJob);
                this.addToCollections(newJobDetail);
                newJobDetail.engageTriggers();
            }
            for (JobKey existingJob : loadedJobConfig.keySet()) {
                if (newJobKeys.contains(existingJob)) continue;
                InternalJobDetail jobDetail = this.keyToJobMap.get(existingJob);
                deletedJobs.put(existingJob, jobDetail);
                JobConfig deletedJobConfig = jobDetail.baseConfig;
                deletedJobTypes.add(deletedJobConfig);
                this.removeJob(jobDetail);
            }
        }
        this.flushDirtyTriggersToIndex();
        if (newJobs.size() != 0 || updatedJobs.size() != 0 || deletedJobs.size() != 0) {
            this.signaler.signalSchedulingChange(0L);
            log.info("Job update finished.\nNew Jobs: " + newJobs.values() + "\nUpdated Jobs: " + updatedJobs.values() + "\nDeleted Jobs: " + deletedJobs.values());
            this.notifyJobConfigListenersAfterChange(newJobTypes, updatedJobTypes, deletedJobTypes);
            return "new: " + newJobs.values().size() + "; upd: " + updatedJobs.size() + "; del: " + deletedJobs.size();
        }
        log.info("Job update finished. Nothing changed.");
        return "no changes";
    }

    public void addJobConfigListener(JobConfigListener<JobType> jobCofigListener) {
        this.jobConfigListeners.add(jobCofigListener);
    }

    private void notifyJobConfigInitListeners(Set<JobType> jobs) {
        for (JobConfigListener<JobType> listener : this.jobConfigListeners) {
            try {
                listener.onInit(jobs);
            }
            catch (Exception e) {
                log.error("Exception in JobConfigListener.onInit()", (Throwable)e);
            }
        }
    }

    private void notifyJobConfigListenersBeforeChange(Set<JobType> newJobs) {
        for (JobConfigListener<JobType> listener : this.jobConfigListeners) {
            try {
                listener.beforeChange(newJobs);
            }
            catch (Exception e) {
                log.error("Exception in JobConfigListener.beforeChange()", (Throwable)e);
            }
        }
    }

    private void notifyJobConfigListenersAfterChange(Set<JobType> newJobs, Map<JobType, JobType> updatedJobs, Set<JobType> deletedJobs) {
        for (JobConfigListener<JobType> listener : this.jobConfigListeners) {
            try {
                listener.afterChange(newJobs, updatedJobs, deletedJobs);
            }
            catch (Exception e) {
                log.error("Exception in JobConfigListener.afterChange()", (Throwable)e);
            }
        }
    }

    private synchronized boolean updateJob(InternalJobDetail existingJobDetail, JobType existingJobConfig, JobType newJobConfig) {
        existingJobDetail.baseConfig = newJobConfig;
        JobDetail newJobDetail = this.jobFactory.createJobDetail(newJobConfig);
        boolean changed = false;
        if (!this.areJobDetailsEqual(existingJobDetail, newJobDetail)) {
            existingJobDetail.delegate = newJobDetail;
            changed = true;
        }
        if (this.updateTriggers(existingJobDetail, existingJobConfig, newJobConfig)) {
            changed = true;
        }
        return changed;
    }

    private boolean areJobDetailsEqual(JobDetail existingJobDetail, JobDetail newJobDetail) {
        if (!com.google.common.base.Objects.equal((Object)existingJobDetail.getDescription(), (Object)newJobDetail.getDescription())) {
            return false;
        }
        if (existingJobDetail.getJobClass() != newJobDetail.getJobClass()) {
            return false;
        }
        if (existingJobDetail.isDurable() != newJobDetail.isDurable()) {
            return false;
        }
        return com.google.common.base.Objects.equal((Object)existingJobDetail.getJobDataMap(), (Object)newJobDetail.getJobDataMap());
    }

    private synchronized boolean updateTriggers(InternalJobDetail existingJobDetail, JobType existingJobConfig, JobType newJobConfig) {
        Map<TriggerKey, InternalOperableTrigger> existingTriggers = existingJobDetail.getTriggersAsMap();
        HashMap<TriggerKey, InternalOperableTrigger> existingTriggersNotInNewTriggers = new HashMap<TriggerKey, InternalOperableTrigger>(existingTriggers);
        HashSet<TriggerKey> newTriggerKeys = new HashSet<TriggerKey>();
        HashMap<TriggerKey, InternalOperableTrigger> newTriggers = new HashMap<TriggerKey, InternalOperableTrigger>();
        HashMap<TriggerKey, InternalOperableTrigger> changedTriggers = new HashMap<TriggerKey, InternalOperableTrigger>();
        boolean changed = false;
        for (Trigger trigger : newJobConfig.getTriggers()) {
            newTriggerKeys.add(trigger.getKey());
            InternalOperableTrigger existingTrigger = existingTriggers.get(trigger.getKey());
            if (existingTrigger == null) {
                InternalOperableTrigger newInternalOperableTrigger = this.storeTriggerInHeap(existingJobDetail, (OperableTrigger)trigger);
                newInternalOperableTrigger.markDirty();
                newTriggers.put(newInternalOperableTrigger.getKey(), newInternalOperableTrigger);
                changed = true;
                continue;
            }
            if (!existingTrigger.delegate.equals(trigger)) {
                existingTrigger.delegate = (OperableTrigger)trigger;
                existingTrigger.markDirty();
                changedTriggers.put(existingTrigger.getKey(), existingTrigger);
                changed = true;
                existingTriggersNotInNewTriggers.remove(existingTrigger.getKey());
                continue;
            }
            existingTriggersNotInNewTriggers.remove(existingTrigger.getKey());
        }
        for (Map.Entry entry : existingTriggersNotInNewTriggers.entrySet()) {
            this.keyToTriggerMap.remove(entry.getKey());
            this.groupAndKeyToTriggerMap.remove((Object)((TriggerKey)entry.getKey()).getGroup(), entry.getKey());
            this.activeTriggers.remove((InternalOperableTrigger)entry.getValue());
            ((InternalOperableTrigger)entry.getValue()).jobDetail.triggers.remove(entry.getValue());
            changed = true;
        }
        if (changed) {
            log.info("Updated triggers of " + existingJobDetail + ":\nNew triggers: " + newTriggers + "\nChanged triggers: " + changedTriggers + "\nRemoved triggers: " + existingTriggersNotInNewTriggers);
        } else {
            log.info("No triggers of " + existingJobConfig + " have been changed");
        }
        return changed;
    }

    private synchronized void removeJob(InternalJobDetail jobDetail) {
        if (jobDetail == null) {
            return;
        }
        JobKey jobKey = jobDetail.getKey();
        this.groupAndKeyToJobMap.remove((Object)jobKey.getGroup(), (Object)jobKey);
        this.blockedJobs.remove(jobKey);
        this.keyToJobMap.remove(jobKey);
        for (InternalOperableTrigger trigger : jobDetail.triggers) {
            TriggerKey triggerKey = trigger.getKey();
            this.groupAndKeyToTriggerMap.remove((Object)triggerKey.getGroup(), (Object)triggerKey);
            this.keyToTriggerMap.remove(triggerKey);
            this.activeTriggers.remove(trigger);
        }
    }

    private InternalJobDetail createInternalJobDetailFromJobConfig(JobType jobConfig, Map<TriggerKey, InternalOperableTrigger> triggerStates) {
        InternalJobDetail internalJobDetail = new InternalJobDetail(this.jobFactory.createJobDetail(jobConfig), (JobConfig)jobConfig, this);
        for (Trigger triggerConfig : jobConfig.getTriggers()) {
            if (!(triggerConfig instanceof OperableTrigger)) {
                log.error("Trigger is not OperableTrigger: " + triggerConfig);
                continue;
            }
            OperableTrigger operableTriggerConfig = (OperableTrigger)triggerConfig;
            InternalOperableTrigger internalOperableTrigger = triggerStates.get(triggerConfig.getKey());
            if (internalOperableTrigger != null) {
                internalOperableTrigger.setDelegate(operableTriggerConfig);
                this.checkTriggerStateAfterRecovery(internalOperableTrigger);
            } else {
                internalOperableTrigger = new InternalOperableTrigger(this, operableTriggerConfig);
                internalOperableTrigger.computeFirstFireTime(null);
                internalOperableTrigger.node = this.nodeId;
                this.updateTriggerStateToIdle(internalOperableTrigger);
            }
            internalJobDetail.addTrigger(internalOperableTrigger);
        }
        return internalJobDetail;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkTriggersStillExecutingOnOtherNodes() {
        HashSet<TriggerKey> triggerKeys;
        IndexJobStateStore indexJobStateStore = this;
        synchronized (indexJobStateStore) {
            if (this.triggersStillExecutingOnOtherNodes.isEmpty()) {
                return;
            }
            triggerKeys = new HashSet<TriggerKey>();
            Iterator<InternalOperableTrigger> iter = this.triggersStillExecutingOnOtherNodes.iterator();
            while (iter.hasNext()) {
                InternalOperableTrigger trigger = iter.next();
                if (trigger.getState() == InternalOperableTrigger.State.EXECUTING) {
                    triggerKeys.add(trigger.getKey());
                    continue;
                }
                iter.remove();
            }
        }
        if (triggerKeys.isEmpty()) {
            return;
        }
        ArrayList<String> triggerKeysAsString = new ArrayList<String>(triggerKeys.size());
        for (TriggerKey triggerKey : triggerKeys) {
            triggerKeysAsString.add(triggerKey.toString());
        }
        this.client.execute((ActionType)CheckForExecutingTriggerAction.INSTANCE, (ActionRequest)new CheckForExecutingTriggerRequest(this.schedulerName, new ArrayList<String>(triggerKeysAsString)), (ActionListener)new ActionListener<CheckForExecutingTriggerResponse>(){

            public void onResponse(CheckForExecutingTriggerResponse response) {
                HashSet triggersToBeReset = new HashSet(triggerKeys);
                triggersToBeReset.removeAll(response.getAllRunningTriggerKeys());
                log.info("Triggers to be reset after CheckForExecutingTriggerAction: " + triggersToBeReset);
                if (triggersToBeReset.size() > 0) {
                    IndexJobStateStore.this.resetTriggersFormerlyRunningOnOtherNodes(triggersToBeReset);
                }
                if (IndexJobStateStore.this.triggersStillExecutingOnOtherNodes.size() > 0) {
                    IndexJobStateStore.this.periodicMaintenanceExecutor.getQueue().clear();
                    IndexJobStateStore.this.periodicMaintenanceExecutor.schedule(() -> IndexJobStateStore.this.checkTriggersStillExecutingOnOtherNodes(), 10L, TimeUnit.SECONDS);
                }
            }

            public void onFailure(Exception e) {
                log.error("CheckForExecutingTriggerAction failed", (Throwable)e);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetTriggersFormerlyRunningOnOtherNodes(Set<TriggerKey> triggersToBeReset) {
        Map<TriggerKey, InternalOperableTrigger> triggerStates = this.loadTriggerStatesByTriggerKeys(triggersToBeReset);
        IndexJobStateStore indexJobStateStore = this;
        synchronized (indexJobStateStore) {
            for (InternalOperableTrigger refreshedTrigger : triggerStates.values()) {
                InternalOperableTrigger actualTrigger = this.keyToTriggerMap.get(refreshedTrigger.getKey());
                if (actualTrigger == null) {
                    log.error("Could not find actualTrigger for " + refreshedTrigger);
                    continue;
                }
                this.triggersStillExecutingOnOtherNodes.remove(actualTrigger);
                InternalJobDetail internalJobDetail = actualTrigger.getJobDetail();
                if (actualTrigger.getState() != InternalOperableTrigger.State.EXECUTING) continue;
                if (refreshedTrigger.getState() == InternalOperableTrigger.State.EXECUTING) {
                    if (actualTrigger.getNextFireTime() == null) {
                        actualTrigger.computeFirstFireTime(null);
                    }
                    actualTrigger.node = this.nodeId;
                    this.updateTriggerStateToIdle(actualTrigger);
                } else {
                    actualTrigger.nextFireTime = refreshedTrigger.nextFireTime;
                    actualTrigger.state = refreshedTrigger.state;
                    actualTrigger.previousFireTime = refreshedTrigger.previousFireTime;
                    actualTrigger.node = this.nodeId;
                    actualTrigger.timesTriggered = refreshedTrigger.timesTriggered;
                }
                if (actualTrigger.state != InternalOperableTrigger.State.WAITING) continue;
                if (internalJobDetail.isConcurrentExectionDisallowed()) {
                    internalJobDetail.deblockTriggers();
                    this.signaler.signalSchedulingChange(0L);
                }
                this.activeTriggers.add(actualTrigger);
            }
        }
        this.flushDirtyTriggersToIndex();
    }

    private synchronized Map<JobKey, JobType> getLoadedJobConfig() {
        HashMap<JobKey, JobConfig> result = new HashMap<JobKey, JobConfig>(this.keyToJobMap.size());
        for (Map.Entry<JobKey, InternalJobDetail> entry : this.keyToJobMap.entrySet()) {
            result.put(entry.getKey(), entry.getValue().baseConfig);
        }
        return result;
    }

    private synchronized void checkTriggerStateAfterRecovery(InternalOperableTrigger internalOperableTrigger) {
        switch (internalOperableTrigger.getState()) {
            case EXECUTING: {
                if (this.nodeId.equals(internalOperableTrigger.getNode())) {
                    log.info("Trigger " + internalOperableTrigger + " is still executing on local node.");
                    break;
                }
                log.info("Trigger " + internalOperableTrigger + " is marked as still executing on node " + internalOperableTrigger.getNode());
                this.triggersStillExecutingOnOtherNodes.add(internalOperableTrigger);
                break;
            }
            case ACQUIRED: 
            case BLOCKED: 
            case WAITING: {
                if (internalOperableTrigger.getNextFireTime() == null) {
                    internalOperableTrigger.computeFirstFireTime(null);
                }
                internalOperableTrigger.node = this.nodeId;
                this.updateTriggerStateToIdle(internalOperableTrigger);
                break;
            }
            case PAUSED_BLOCKED: {
                if (internalOperableTrigger.getNextFireTime() == null) {
                    internalOperableTrigger.computeFirstFireTime(null);
                }
                internalOperableTrigger.setStateAndNode(InternalOperableTrigger.State.PAUSED, this.nodeId);
                break;
            }
        }
    }

    private Map<TriggerKey, InternalOperableTrigger> loadTriggerStates(Set<JobType> jobConfig) {
        Map<String, TriggerKey> triggerIds = this.getTriggerIds(jobConfig);
        return this.loadTriggerStates(triggerIds);
    }

    private Map<TriggerKey, InternalOperableTrigger> loadTriggerStatesByTriggerKeys(Set<TriggerKey> triggerKeys) {
        Map<String, TriggerKey> triggerIds = this.getTriggerIdsByTriggerKeys(triggerKeys);
        return this.loadTriggerStates(triggerIds);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<TriggerKey, InternalOperableTrigger> loadTriggerStates(Map<String, TriggerKey> triggerIds) {
        try {
            if (triggerIds.isEmpty()) {
                return Collections.emptyMap();
            }
            HashMap<TriggerKey, InternalOperableTrigger> result = new HashMap<TriggerKey, InternalOperableTrigger>(triggerIds.size());
            IdsQueryBuilder queryBuilder = QueryBuilders.idsQuery().addIds(triggerIds.keySet().toArray(new String[triggerIds.size()]));
            SearchResponse searchResponse = (SearchResponse)this.client.prepareSearch(new String[]{this.statusIndexName}).setQuery((QueryBuilder)queryBuilder).setSize(1000).setScroll(new TimeValue(10000L)).get();
            try {
                do {
                    for (SearchHit searchHit : searchResponse.getHits().getHits()) {
                        try {
                            TriggerKey triggerKey = triggerIds.get(searchHit.getId());
                            InternalOperableTrigger internalOperableTrigger = InternalOperableTrigger.fromAttributeMap(this, triggerKey, searchHit.getSourceAsMap());
                            result.put(triggerKey, internalOperableTrigger);
                        }
                        catch (Exception e) {
                            log.error("Error while loading " + searchHit, (Throwable)e);
                        }
                    }
                } while ((searchResponse = (SearchResponse)this.client.prepareSearchScroll(searchResponse.getScrollId()).setScroll(new TimeValue(10000L)).execute().actionGet()).getHits().getHits().length != 0);
            }
            finally {
                Actions.clearScrollAsync((Client)this.client, (SearchResponse)searchResponse);
            }
            return result;
        }
        catch (IndexNotFoundException e) {
            return Collections.emptyMap();
        }
        catch (ElasticsearchException e) {
            log.error("Error in loadTriggerStates()", (Throwable)e);
            throw e;
        }
    }

    private Map<String, TriggerKey> getTriggerIds(Set<JobType> jobConfig) {
        HashMap<String, TriggerKey> result = new HashMap<String, TriggerKey>(jobConfig.size() * 3);
        for (JobConfig job : jobConfig) {
            for (Trigger trigger : job.getTriggers()) {
                result.put(this.quartzKeyToKeyString((Key<?>)trigger.getKey()), trigger.getKey());
            }
        }
        return result;
    }

    private Map<String, TriggerKey> getTriggerIdsByTriggerKeys(Set<TriggerKey> triggerKeys) {
        HashMap<String, TriggerKey> result = new HashMap<String, TriggerKey>(triggerKeys.size());
        for (TriggerKey triggerKey : triggerKeys) {
            result.put(this.quartzKeyToKeyString((Key<?>)triggerKey), triggerKey);
        }
        return result;
    }

    private Set<JobType> loadJobConfigAfterReachingYellowStatus() {
        try {
            ClusterHealthResponse clusterHealthResponse = (ClusterHealthResponse)this.client.admin().cluster().prepareHealth(new String[0]).setWaitForYellowStatus().setWaitForNoInitializingShards(true).setTimeout(TimeValue.timeValueSeconds((long)1L)).execute().actionGet();
            if (log.isDebugEnabled()) {
                log.debug("Cluster health before loading job config: " + clusterHealthResponse);
            }
            if (clusterHealthResponse.isTimedOut()) {
                log.warn("Timeout while waiting for initialized cluster status. Will try to continue anyway. " + clusterHealthResponse);
            }
        }
        catch (ElasticsearchException e) {
            log.error("Error while getting cluster health ", (Throwable)e);
            throw e;
        }
        return Sets.newHashSet(this.jobConfigSource);
    }

    private Set<JobType> loadJobConfig() {
        return Sets.newHashSet(this.jobConfigSource);
    }

    private String quartzKeyToKeyString(Key<?> key) {
        if (this.statusIndexIdPrefix != null) {
            return this.escapePeriod(this.statusIndexIdPrefix) + "." + this.escapePeriod(key.getGroup()) + "." + this.escapePeriod(key.getName());
        }
        return this.escapePeriod(key.getGroup()) + "." + this.escapePeriod(key.getName());
    }

    private String escapePeriod(String string) {
        if (string == null) {
            return null;
        }
        if (!this.needsEscapePeriod(string)) {
            return string;
        }
        int length = string.length();
        StringBuilder result = new StringBuilder(length * 2);
        for (int i = 0; i < length; ++i) {
            char c = string.charAt(i);
            if (c == '.') {
                result.append("\\.");
                continue;
            }
            if (c == '\\') {
                result.append("\\\\");
                continue;
            }
            result.append(c);
        }
        return result.toString();
    }

    private boolean needsEscapePeriod(String string) {
        int length = string.length();
        for (int i = 0; i < length; ++i) {
            char c = string.charAt(i);
            if (c != '.' && c != '\\') continue;
            return true;
        }
        return false;
    }

    private boolean checkForMisfire(InternalOperableTrigger internalOperableTrigger) {
        return this.checkForMisfire(internalOperableTrigger, System.currentTimeMillis() - this.misfireThreshold);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkForMisfire(InternalOperableTrigger internalOperableTrigger, long isMisfireBefore) {
        Date nextFireTime = internalOperableTrigger.getNextFireTime();
        if (nextFireTime == null || nextFireTime.getTime() > isMisfireBefore || internalOperableTrigger.getMisfireInstruction() == -1) {
            return false;
        }
        Calendar calendar = null;
        if (internalOperableTrigger.getCalendarName() != null) {
            calendar = this.retrieveCalendar(internalOperableTrigger.getCalendarName());
        }
        this.signaler.notifyTriggerListenersMisfired((Trigger)((OperableTrigger)internalOperableTrigger.getDelegate().clone()));
        internalOperableTrigger.updateAfterMisfire(calendar);
        this.markDirty(internalOperableTrigger);
        if (internalOperableTrigger.getNextFireTime() == null) {
            IndexJobStateStore indexJobStateStore = this;
            synchronized (indexJobStateStore) {
                internalOperableTrigger.state = InternalOperableTrigger.State.COMPLETE;
                this.activeTriggers.remove(internalOperableTrigger);
            }
            this.signaler.notifySchedulerListenersFinalized((Trigger)internalOperableTrigger);
            return true;
        }
        return !nextFireTime.equals(internalOperableTrigger.getNextFireTime());
    }

    private void markDirty(InternalOperableTrigger trigger) {
        this.dirtyTriggers.get().add(trigger);
    }

    private void flushDirtyTriggersToIndex() {
        HashSet triggers = new HashSet(this.dirtyTriggers.get());
        this.dirtyTriggers.get().clear();
        if (log.isDebugEnabled()) {
            log.debug("Flushing dirty triggers: " + triggers);
        }
        for (OperableTrigger trigger : triggers) {
            this.setTriggerStatusInIndex((InternalOperableTrigger)trigger);
        }
    }

    @Override
    public boolean isInitialized() {
        return this.initialized;
    }

    public String toString() {
        return "IndexJobStateStore [schedulerName=" + this.schedulerName + ", statusIndexName=" + this.statusIndexName + ", jobConfigSource=" + this.jobConfigSource + ", jobFactory=" + this.jobFactory + "]";
    }

    static class ActiveTrigger
    implements Trigger {
        private static final long serialVersionUID = -4666180063413542273L;
        static final Trigger.TriggerTimeComparator COMPARATOR = new Trigger.TriggerTimeComparator();
        private final InternalOperableTrigger delegate;
        private final boolean mayFireAgain;
        private final Date startTime;
        private final Date endTime;
        private final Date nextFireTime;
        private final Date previousFireTime;
        private final Date finalFireTime;

        ActiveTrigger(InternalOperableTrigger delegate) {
            this.delegate = delegate;
            this.mayFireAgain = delegate.mayFireAgain();
            this.startTime = ActiveTrigger.copyDate(delegate.getStartTime());
            this.endTime = ActiveTrigger.copyDate(delegate.getEndTime());
            this.nextFireTime = ActiveTrigger.copyDate(delegate.getNextFireTime());
            this.previousFireTime = ActiveTrigger.copyDate(delegate.getPreviousFireTime());
            this.finalFireTime = ActiveTrigger.copyDate(delegate.getFinalFireTime());
        }

        public TriggerKey getKey() {
            return this.delegate.getKey();
        }

        public JobKey getJobKey() {
            return this.delegate.getJobKey();
        }

        public String getDescription() {
            return this.delegate.getDescription();
        }

        public String getCalendarName() {
            return this.delegate.getCalendarName();
        }

        public JobDataMap getJobDataMap() {
            return this.delegate.getJobDataMap();
        }

        public int getPriority() {
            return this.delegate.getPriority();
        }

        public boolean mayFireAgain() {
            return this.mayFireAgain;
        }

        public Date getStartTime() {
            return this.startTime;
        }

        public Date getEndTime() {
            return this.endTime;
        }

        public Date getNextFireTime() {
            return this.nextFireTime;
        }

        public Date getPreviousFireTime() {
            return this.previousFireTime;
        }

        public Date getFireTimeAfter(Date afterTime) {
            throw new UnsupportedOperationException();
        }

        public Date getFinalFireTime() {
            return this.finalFireTime;
        }

        public int getMisfireInstruction() {
            return this.delegate.getMisfireInstruction();
        }

        public TriggerBuilder<? extends Trigger> getTriggerBuilder() {
            return this.delegate.getTriggerBuilder();
        }

        public ScheduleBuilder<? extends Trigger> getScheduleBuilder() {
            return this.delegate.getScheduleBuilder();
        }

        public int compareTo(Trigger other) {
            return COMPARATOR.compare((Trigger)this, other);
        }

        public String toString() {
            return this.delegate.getKey().toString();
        }

        private static Date copyDate(Date date) {
            if (date != null) {
                return new Date(date.getTime());
            }
            return null;
        }

        static /* synthetic */ InternalOperableTrigger access$200(ActiveTrigger x0) {
            return x0.delegate;
        }
    }

    static class ActiveTriggerQueue {
        private final TreeSet<ActiveTrigger> queue = new TreeSet(ActiveTrigger.COMPARATOR);
        private final Map<TriggerKey, ActiveTrigger> keyToActiveTriggerMap = new HashMap<TriggerKey, ActiveTrigger>();

        ActiveTriggerQueue() {
        }

        void add(InternalOperableTrigger trigger) {
            ActiveTrigger activeTrigger = new ActiveTrigger(trigger);
            ActiveTrigger oldActiveTrigger = this.keyToActiveTriggerMap.put(trigger.getKey(), activeTrigger);
            if (oldActiveTrigger != null) {
                this.queue.remove(oldActiveTrigger);
            }
            this.queue.add(activeTrigger);
        }

        void addAll(Collection<InternalOperableTrigger> triggers) {
            for (InternalOperableTrigger trigger : triggers) {
                this.add(trigger);
            }
        }

        void remove(InternalOperableTrigger trigger) {
            ActiveTrigger oldActiveTrigger = this.keyToActiveTriggerMap.remove(trigger.getKey());
            if (oldActiveTrigger != null) {
                this.queue.remove(oldActiveTrigger);
            }
        }

        boolean isEmpty() {
            return this.queue.isEmpty();
        }

        int size() {
            return this.queue.size();
        }

        ActiveTrigger pollFirst() {
            ActiveTrigger result = this.queue.pollFirst();
            if (result != null) {
                this.keyToActiveTriggerMap.remove(result.getKey());
            }
            return result;
        }

        void clear() {
            this.queue.clear();
            this.keyToActiveTriggerMap.clear();
        }

        public String toString() {
            return this.queue.toString();
        }
    }

    static class InternalOperableTrigger
    implements OperableTrigger,
    ToXContentObject {
        private static final long serialVersionUID = -181071146931763579L;
        private OperableTrigger delegate;
        private final TriggerKey key;
        private final String keyString;
        private final IndexJobStateStore<?> jobStore;
        private State state = State.WAITING;
        private String stateInfo = null;
        private String node;
        private Date previousFireTime;
        private Date nextFireTime;
        private Integer timesTriggered;
        private InternalJobDetail jobDetail;

        InternalOperableTrigger(IndexJobStateStore<?> jobStore, TriggerKey key) {
            this.key = Objects.requireNonNull(key, "TriggerKey must not be null");
            this.keyString = ((IndexJobStateStore)jobStore).quartzKeyToKeyString((Key)key);
            this.jobStore = jobStore;
        }

        InternalOperableTrigger(IndexJobStateStore<?> jobStore, OperableTrigger operableTrigger) {
            this(jobStore, operableTrigger.getKey());
            this.delegate = operableTrigger;
        }

        public void triggered(Calendar calendar) {
            this.delegate.triggered(calendar);
        }

        public Date computeFirstFireTime(Calendar calendar) {
            return this.delegate.computeFirstFireTime(calendar);
        }

        public void setKey(TriggerKey key) {
            this.delegate.setKey(key);
        }

        public void setJobKey(JobKey key) {
            this.delegate.setJobKey(key);
        }

        public void setDescription(String description) {
            this.delegate.setDescription(description);
        }

        public void setCalendarName(String calendarName) {
            this.delegate.setCalendarName(calendarName);
        }

        public Trigger.CompletedExecutionInstruction executionComplete(JobExecutionContext context, JobExecutionException result) {
            return this.delegate.executionComplete(context, result);
        }

        public void setJobDataMap(JobDataMap jobDataMap) {
            this.delegate.setJobDataMap(jobDataMap);
        }

        public void setPriority(int priority) {
            this.delegate.setPriority(priority);
        }

        public void setStartTime(Date startTime) {
            this.delegate.setStartTime(startTime);
        }

        public void updateAfterMisfire(Calendar cal) {
            this.delegate.updateAfterMisfire(cal);
        }

        public void setEndTime(Date endTime) {
            this.delegate.setEndTime(endTime);
        }

        public void updateWithNewCalendar(Calendar cal, long misfireThreshold) {
            this.delegate.updateWithNewCalendar(cal, misfireThreshold);
        }

        public void setMisfireInstruction(int misfireInstruction) {
            this.delegate.setMisfireInstruction(misfireInstruction);
        }

        public void validate() throws SchedulerException {
            this.delegate.validate();
        }

        public Object clone() {
            return new InternalOperableTrigger(this.jobStore, this.delegate);
        }

        public void setFireInstanceId(String id) {
            this.delegate.setFireInstanceId(id);
        }

        public String getFireInstanceId() {
            return this.delegate.getFireInstanceId();
        }

        public void setNextFireTime(Date nextFireTime) {
            this.nextFireTime = nextFireTime;
            if (this.delegate != null) {
                this.delegate.setNextFireTime(nextFireTime);
            }
        }

        public void setPreviousFireTime(Date previousFireTime) {
            this.previousFireTime = previousFireTime;
            if (this.delegate != null) {
                this.delegate.setPreviousFireTime(previousFireTime);
            }
        }

        public TriggerKey getKey() {
            if (this.delegate == null) {
                return this.key;
            }
            return this.delegate.getKey();
        }

        public JobKey getJobKey() {
            return this.delegate.getJobKey();
        }

        public String getDescription() {
            return this.delegate.getDescription();
        }

        public String getCalendarName() {
            return this.delegate.getCalendarName();
        }

        public JobDataMap getJobDataMap() {
            return this.delegate.getJobDataMap();
        }

        public int getPriority() {
            return this.delegate.getPriority();
        }

        public boolean mayFireAgain() {
            return this.delegate.mayFireAgain();
        }

        public Date getStartTime() {
            return this.delegate.getStartTime();
        }

        public Date getEndTime() {
            return this.delegate.getEndTime();
        }

        public Date getNextFireTime() {
            if (this.delegate != null) {
                return this.delegate.getNextFireTime();
            }
            return this.nextFireTime;
        }

        public Date getPreviousFireTime() {
            if (this.delegate != null) {
                return this.delegate.getPreviousFireTime();
            }
            return this.previousFireTime;
        }

        public Date getFireTimeAfter(Date afterTime) {
            return this.delegate.getFireTimeAfter(afterTime);
        }

        public Date getFinalFireTime() {
            return this.delegate.getFinalFireTime();
        }

        public int getMisfireInstruction() {
            return this.delegate.getMisfireInstruction();
        }

        public TriggerBuilder<? extends Trigger> getTriggerBuilder() {
            return this.delegate.getTriggerBuilder();
        }

        public ScheduleBuilder<? extends Trigger> getScheduleBuilder() {
            return this.delegate.getScheduleBuilder();
        }

        public boolean equals(Object other) {
            return this.delegate.equals(other);
        }

        public int compareTo(Trigger other) {
            return this.delegate.compareTo(other);
        }

        public String getKeyString() {
            return this.keyString;
        }

        public OperableTrigger getDelegate() {
            return this.delegate;
        }

        public void setDelegate(OperableTrigger delegate) {
            this.delegate = delegate;
            if (delegate != null) {
                delegate.setPreviousFireTime(this.previousFireTime);
                delegate.setNextFireTime(this.nextFireTime);
                this.setTimesTriggeredInDelegate(this.delegate, this.timesTriggered);
            }
        }

        public State getState() {
            return this.state;
        }

        public void setState(State state) {
            if (this.state == state) {
                return;
            }
            this.state = state;
            this.markDirty();
        }

        public void setStateWithoutMarkingDirty(State state) {
            if (this.state == state) {
                return;
            }
            this.state = state;
        }

        public void setStateAndNode(State state, String nodeId) {
            if (this.state == state && com.google.common.base.Objects.equal((Object)this.node, (Object)nodeId)) {
                return;
            }
            this.state = state;
            this.node = nodeId;
            this.markDirty();
        }

        public String toString() {
            return this.key + " " + (Object)((Object)this.state) + " " + this.getPreviousFireTime() + " <-> " + this.getNextFireTime();
        }

        void markDirty() {
            if (this.jobDetail != null) {
                ((IndexJobStateStore)this.jobDetail.jobStore).markDirty(this);
            }
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field("state", this.state.toString());
            builder.field("nextFireTime", this.getNextFireTime() != null ? Long.valueOf(this.getNextFireTime().getTime()) : null);
            builder.field("prevFireTime", this.getPreviousFireTime() != null ? Long.valueOf(this.getPreviousFireTime().getTime()) : null);
            builder.field("info", this.stateInfo);
            builder.field("node", this.node);
            builder.field("timesTriggered", this.getTimesTriggered());
            builder.endObject();
            return builder;
        }

        public static InternalOperableTrigger fromAttributeMap(IndexJobStateStore<?> jobStore, TriggerKey triggerKey, Map<String, Object> attributeMap) {
            InternalOperableTrigger result = new InternalOperableTrigger(jobStore, triggerKey);
            try {
                result.state = State.valueOf((String)attributeMap.get("state"));
                result.node = (String)attributeMap.get("node");
                result.setNextFireTime(InternalOperableTrigger.toDate(attributeMap.get("nextFireTime")));
                result.setPreviousFireTime(InternalOperableTrigger.toDate(attributeMap.get("prevFireTime")));
                result.stateInfo = (String)attributeMap.get("info");
                result.setTimesTriggered(attributeMap.get("timesTriggered") instanceof Number ? Integer.valueOf(((Number)attributeMap.get("timesTriggered")).intValue()) : null);
            }
            catch (Exception e) {
                log.error("Error while parsing trigger " + triggerKey, (Throwable)e);
                result.state = State.ERROR;
                result.stateInfo = "Error while parsing " + e;
            }
            return result;
        }

        private static Date toDate(Object time) {
            if (time instanceof Number) {
                return new Date(((Number)time).longValue());
            }
            return null;
        }

        public String getStateInfo() {
            return this.stateInfo;
        }

        public void setStateInfo(String stateInfo) {
            this.stateInfo = stateInfo;
        }

        public String getNode() {
            return this.node;
        }

        public void setNode(String node) {
            this.node = node;
        }

        public Integer getTimesTriggered() {
            if (this.delegate instanceof DailyTimeIntervalTrigger) {
                return ((DailyTimeIntervalTrigger)this.delegate).getTimesTriggered();
            }
            if (this.delegate instanceof SimpleTrigger) {
                return ((SimpleTrigger)this.delegate).getTimesTriggered();
            }
            return this.timesTriggered;
        }

        public void setTimesTriggered(Integer timesTriggered) {
            this.timesTriggered = timesTriggered;
            this.setTimesTriggeredInDelegate(this.delegate, timesTriggered);
        }

        public void setTimesTriggeredInDelegate(OperableTrigger delegate, Integer timesTriggered) {
            if (delegate instanceof CalendarIntervalTriggerImpl) {
                ((CalendarIntervalTriggerImpl)delegate).setTimesTriggered(timesTriggered != null ? timesTriggered : 0);
            } else if (delegate instanceof DailyTimeIntervalTriggerImpl) {
                ((DailyTimeIntervalTriggerImpl)delegate).setTimesTriggered(timesTriggered != null ? timesTriggered : 0);
            } else if (delegate instanceof SimpleTriggerImpl) {
                ((SimpleTriggerImpl)delegate).setTimesTriggered(timesTriggered != null ? timesTriggered : 0);
            }
        }

        public InternalJobDetail getJobDetail() {
            return this.jobDetail;
        }

        public void setJobDetail(InternalJobDetail jobDetail) {
            this.jobDetail = jobDetail;
        }

        static enum State {
            WAITING(Trigger.TriggerState.NORMAL),
            ACQUIRED(Trigger.TriggerState.NORMAL),
            EXECUTING(Trigger.TriggerState.NORMAL),
            COMPLETE(Trigger.TriggerState.COMPLETE),
            BLOCKED(Trigger.TriggerState.BLOCKED),
            ERROR(Trigger.TriggerState.ERROR),
            PAUSED(Trigger.TriggerState.PAUSED),
            PAUSED_BLOCKED(Trigger.TriggerState.PAUSED),
            DELETED(Trigger.TriggerState.NORMAL);

            private final Trigger.TriggerState triggerState;

            private State(Trigger.TriggerState triggerState) {
                this.triggerState = triggerState;
            }

            public Trigger.TriggerState getTriggerState() {
                return this.triggerState;
            }
        }
    }

    static class InternalJobDetail
    implements JobDetail,
    JobDetailWithBaseConfig {
        private static final long serialVersionUID = -4500332272991179774L;
        private JobDetail delegate;
        private final IndexJobStateStore<?> jobStore;
        private List<InternalOperableTrigger> triggers = new ArrayList<InternalOperableTrigger>();
        private JobConfig baseConfig;

        InternalJobDetail(JobDetail jobDetail, JobConfig baseConfig, IndexJobStateStore<?> jobStore) {
            this.delegate = jobDetail;
            this.baseConfig = baseConfig;
            this.jobStore = jobStore;
        }

        public void addTrigger(InternalOperableTrigger trigger) {
            this.triggers.add(trigger);
            trigger.setJobDetail(this);
        }

        public JobKey getKey() {
            return this.delegate.getKey();
        }

        public String getDescription() {
            return this.delegate.getDescription();
        }

        public Class<? extends Job> getJobClass() {
            return this.delegate.getJobClass();
        }

        public JobDataMap getJobDataMap() {
            return this.delegate.getJobDataMap();
        }

        public boolean isDurable() {
            return this.delegate.isDurable();
        }

        public boolean isPersistJobDataAfterExecution() {
            return this.delegate.isPersistJobDataAfterExecution();
        }

        public boolean isConcurrentExectionDisallowed() {
            return this.delegate.isConcurrentExectionDisallowed();
        }

        public boolean requestsRecovery() {
            return this.delegate.requestsRecovery();
        }

        public JobBuilder getJobBuilder() {
            return this.delegate.getJobBuilder();
        }

        @Override
        public JobConfig getBaseConfig() {
            return this.baseConfig;
        }

        @Override
        public <T> T getBaseConfig(Class<T> type) {
            return type.cast(this.baseConfig);
        }

        public Object clone() {
            return new InternalJobDetail(this.delegate, this.baseConfig, this.jobStore);
        }

        public int hashCode() {
            int prime = 31;
            JobKey key = this.getKey();
            int result = 1;
            result = 31 * result + (key == null ? 0 : key.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof JobDetail)) {
                return false;
            }
            JobDetail other = (JobDetail)obj;
            JobKey key = this.getKey();
            return !(key == null ? other.getKey() != null : !key.equals((Object)other.getKey()));
        }

        public String toString() {
            return "InternalJobDetail [key=" + this.getKey() + ", class=" + this.getJobClass() + ", jobDataMap=" + new HashMap(this.getJobDataMap()) + ", triggers=" + this.triggers + "]";
        }

        void blockIdleTriggers() {
            for (InternalOperableTrigger trigger : this.triggers) {
                if (trigger.state == InternalOperableTrigger.State.WAITING) {
                    trigger.setState(InternalOperableTrigger.State.BLOCKED);
                } else if (trigger.state == InternalOperableTrigger.State.PAUSED) {
                    trigger.setState(InternalOperableTrigger.State.PAUSED_BLOCKED);
                }
                ((IndexJobStateStore)this.jobStore).activeTriggers.remove(trigger);
            }
            ((IndexJobStateStore)this.jobStore).blockedJobs.add(this.getKey());
        }

        void deblockTriggers() {
            ((IndexJobStateStore)this.jobStore).blockedJobs.remove(this.getKey());
            for (InternalOperableTrigger trigger : this.triggers) {
                if (trigger.state == InternalOperableTrigger.State.BLOCKED) {
                    trigger.setState(InternalOperableTrigger.State.WAITING);
                    ((IndexJobStateStore)this.jobStore).activeTriggers.add(trigger);
                    continue;
                }
                if (trigger.state != InternalOperableTrigger.State.PAUSED_BLOCKED) continue;
                trigger.setState(InternalOperableTrigger.State.PAUSED);
            }
        }

        void engageTriggers() {
            for (InternalOperableTrigger trigger : this.triggers) {
                if (trigger.state == InternalOperableTrigger.State.WAITING) {
                    ((IndexJobStateStore)this.jobStore).activeTriggers.add(trigger);
                    continue;
                }
                ((IndexJobStateStore)this.jobStore).activeTriggers.remove(trigger);
            }
        }

        Map<TriggerKey, InternalOperableTrigger> getTriggersAsMap() {
            return this.triggers.stream().collect(Collectors.toMap(Trigger::getKey, Function.identity()));
        }
    }
}

